/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.idm.trident;

import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.ClassDescriptions;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.IVWIDMDocClass;
import filenet.vw.idm.toolkit.IVWIDMLink;
import filenet.vw.idm.toolkit.IVWIDMPropertyDescription;
import filenet.vw.idm.trident.VWIDMTridentItem;
import filenet.vw.idm.trident.VWIDMTridentLibrary;
import filenet.vw.idm.trident.VWIDMTridentPropertyDescription;

public final class VWIDMTridentDocClass
implements IVWIDMDocClass {
    private ClassDescription m_classDesc = null;
    private VWIDMTridentLibrary m_lib = null;
    private String m_name = null;
    private static Logger logger = Logger.getLogger("filenet.vw.idm");
    private static final String m_className = "VWIDMTridentDocClass";

    static IVWIDMDocClass[] fromClassDescriptions(ClassDescriptions classDescs, VWIDMTridentLibrary lib) {
        if (classDescs == null) {
            return null;
        }
        int size = classDescs.size();
        IVWIDMDocClass[] res = new VWIDMTridentDocClass[size];
        for (int i = 0; i < size; ++i) {
            res[i] = new VWIDMTridentDocClass((ClassDescription)classDescs.get(i), lib);
        }
        return res;
    }

    static IVWIDMDocClass fromClassDescription(ClassDescription classDesc, VWIDMTridentLibrary lib) {
        if (classDesc == null) {
            return null;
        }
        return new VWIDMTridentDocClass(classDesc, lib);
    }

    protected VWIDMTridentDocClass(ClassDescription classDesc, VWIDMTridentLibrary lib) {
        String m_method = "CTOR";
        this.m_classDesc = classDesc;
        this.m_lib = lib;
        this.getName();
        this.getId();
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, this.m_name);
        }
    }

    public Object getProp(String propName) throws VWException {
        String m_method = "getProp:" + propName;
        if (this.m_classDesc == null) {
            throw new VWException("idm.trident.IDMTridentDocClass.getProp1", "No object is available.");
        }
        try {
            Property prop;
            Object retVal = null;
            Properties props = this.m_classDesc.getProperties(new String[]{propName});
            if (props != null && (prop = (Property)props.get(0)) != null) {
                retVal = VWIDMTridentItem.mapGetPropertyValue(prop.getValue(), propName, prop);
            }
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "value=" + (retVal == null ? "NULL" : retVal.toString()));
            }
            return retVal;
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw new VWException("idm.trident.IDMTridentDocClass.getProp2", "Failed to get property {0}.  {1}", propName, e.getMessage());
        }
    }

    public String getId() {
        return this.m_classDesc.getId();
    }

    public String getName() {
        try {
            if (this.m_name == null) {
                this.m_name = this.m_classDesc.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_name;
    }

    public IVWIDMPropertyDescription[] getPropertyDescriptions() {
        return VWIDMTridentPropertyDescription.fromPropertyDescriptions(this.m_classDesc.getPropertyDescriptions(), this.m_lib);
    }

    public String toString() {
        return this.getName();
    }

    public int countReadOnlyProps() {
        return 0;
    }

    public int countEditableProps() {
        return 0;
    }

    public IVWIDMLink[] getWorkflowLinks(int eventType, int isolatedRegion) throws VWException {
        return null;
    }

    public IVWIDMLink createWorkflowLink(String linkName, String wfSubject, String wfDefID, String wfTitle, int eventType, String expression) throws VWException {
        return null;
    }

    public boolean isWorkflowDefinition() {
        return this.getId().equalsIgnoreCase("{A5C636CD-11BD-455D-9E1A-604A356ABFBA}");
    }

    public boolean isScenarioDefinition() {
        return this.getId().equalsIgnoreCase("{902C0C1F-65DC-4925-B8FA-B4ECA4AD752A}");
    }

    public boolean isSimulation() {
        return this.getId().equalsIgnoreCase("{193E5683-C724-4C3B-8D55-F4091B9B7222}");
    }

    public ClassDescription getClassDescription() {
        return this.m_classDesc;
    }
}

